//This programm is to keep the Zoe awake

#define  a3f    417     // 208 Hz
#define  b3f    468     // 233 Hz
#define  b3     496     // 247 Hz
#define  c4     525     // 261 Hz MIDDLE C
#define  c4s    557     // 277 Hz
#define  e4f    625     // 311 Hz    
#define  f4     701     // 349 Hz 
#define  a4f    834     // 415 Hz  
#define  b4f    936     // 466 Hz 
#define  b4     992     // 493 Hz 
#define  c5     1051     // 523 Hz 
#define  c5s    1114     // 554 Hz
#define  e5f    1250     // 622 Hz  
#define  f5     1403     // 698 Hz 
#define  f5s    1486     // 740 Hz
#define  a5f    1668     // 831 Hz 

#define rest    0

const unsigned int PROGMEM melody[] =
{ b4f, b4f, a4f, a4f,
  f5, f5, e5f, b4f, b4f, a4f, a4f, e5f, e5f, c5s, c5, b4f,
  c5s, c5s, c5s, c5s,
  c5s, e5f, c5, b4f, a4f, a4f, a4f, e5f, c5s,
  b4f, b4f, a4f, a4f,
  f5, f5, e5f, b4f, b4f, a4f, a4f, a5f, c5, c5s, c5, b4f,
  c5s, c5s, c5s, c5s,
  c5s, e5f, c5, b4f, a4f, rest, a4f, e5f, c5s, rest
};

const byte PROGMEM noteDurations[] =
{ 1, 1, 1, 1,
  3, 3, 6, 1, 1, 1, 1, 3, 3, 3, 1, 2,
  1, 1, 1, 1,
  3, 3, 3, 1, 2, 2, 2, 4, 8,
  1, 1, 1, 1,
  3, 3, 6, 1, 1, 1, 1, 3, 3, 3, 1, 2,
  1, 1, 1, 1,
  3, 3, 3, 1, 2, 2, 2, 4, 8, 4
};
//Source for the song: https://create.arduino.cc/projecthub/code_files/530126/download

#define DOOR_IN PB0
#define DOOR_OUT PB2
#define piezo PB1

#define INTERVAL 55000 //run every 55 seconds

uint32_t lastrun;

void setup() {
  // initialize digital pin LED_BUILTIN as an output.
  pinMode(DOOR_IN, INPUT);
  pinMode(DOOR_OUT, OUTPUT);
  digitalWrite(DOOR_OUT, LOW);
}

void loop() {
  if(digitalRead(DOOR_IN) == LOW) {//Door is open
    play_rickroll();
  }
  else {//Door is closed
    if (millis() >= lastrun + INTERVAL) {
      lastrun = millis();
      digitalWrite(DOOR_OUT, HIGH);
      delay(1000);
      digitalWrite(DOOR_OUT, LOW);
    }
  }
}

void play_rickroll() {
  pinMode(piezo, OUTPUT);
  for (byte thisNote = 0; thisNote < 59; thisNote++)
  {
    unsigned int noteDuration = pgm_read_byte_near(noteDurations + thisNote)*100;
    if(melody[thisNote] >= 0)
    {
      tone(piezo, pgm_read_word_near(melody + thisNote),noteDuration);
    }
    delay(noteDuration +30);
    if(digitalRead(DOOR_IN) == HIGH) { //Door is closed, stop playing
       break;
    }
  }
  pinMode(piezo, INPUT); //supresses humming after playing
}